@extends('admin.layout.template')
@section('title', 'Project Details')
@section('content')
<style>
    .card-body{
        box-shadow: rgba(50, 50, 93, 0.25) 0px 13px 27px -5px, rgba(0, 0, 0, 0.3) 0px 8px 16px -8px;
    }
</style>
<div class="page-content">
    <div class="container-xxl">

            {{-- ================= PROJECT HEADER ================= --}}
            <div class="card mb-4 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">

                        {{-- LEFT SIDE --}}
                        <div>
                            <h3 class="mb-2">
                                {{ $project->project_name }}
                                <span class="badge bg-info ms-2">
                                    {{ $project->project_number }}
                                </span>
                            </h3>

                            <div class="row mt-3">
                                <div class="col-md-6">
                                    <p class="mb-1">
                                        <strong>Customer :</strong>
                                        {{ $project->customer_name }}
                                    </p>
                                    <p class="mb-1">
                                        <strong>Phone :</strong>
                                        {{ $project->customer_phone }}
                                    </p>
                                    <p class="mb-1">
                                        <strong>Address :</strong>
                                        {{ $project->address }}
                                    </p>
                                </div>

                                <div class="col-md-6">
                                    <p class="mb-1">
                                        <strong>Project Type :</strong>
                                        {{ $project->project_type ?? '-' }}
                                    </p>

                                    <p class="mb-1">
                                        <strong>Expected Completion :</strong>
                                        {{ $project->expected_completion_date 
                                ? \Carbon\Carbon::parse($project->expected_completion_date)->format('d M Y') 
                                : '-' }}
                                    </p>

                                    <p class="mb-1">
                                        <strong>Status :</strong>
                                        <span class="badge 
                                @if($project->status == 'completed') bg-success
                                @elseif($project->status == 'pending') bg-warning
                                @else bg-secondary
                                @endif">
                                            {{ ucfirst($project->status) }}
                                        </span>
                                    </p>
                                </div>
                            </div>
                        </div>

                        {{-- RIGHT SIDE --}}
                        <div class="text-end">

                            <p class="mb-1">
                                <strong>Employee :</strong>
                                {{ $project->employee_name ?? '-' }}
                            </p>

                            <p class="mb-3">
                                <strong>Contact :</strong>
                                {{ $project->employee_contact ?? '-' }}
                            </p>

                            {{-- PDF Buttons --}}
                            <div class="d-flex gap-2">

                                <a href="{{ url('/api/pdf/measurement/'.$project->id) }}"
                                    class="btn btn-outline-primary btn-sm">
                                    Measurement PDF
                                </a>

                                <a href="{{ url('/api/pdf/quotation/'.$project->id) }}"
                                    class="btn btn-outline-success btn-sm">
                                    Quotation PDF
                                </a>

                                <a href="{{ url('/api/pdf/invoice/'.$project->id) }}"
                                    class="btn btn-outline-danger btn-sm">
                                    Invoice PDF
                                </a>

                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="row mb-2">
                <div class="col-md-4">
                    <div class="card text-center shadow-sm">
                        <div class="card-body">
                            <h6>Subtotal</h6>
                            <h4 class="text-primary">
                                ₹ {{ number_format($project->subtotal, 2) }}
                            </h4>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm">
                        <div class="card-body">
                            <h6>GST (18%)</h6>
                            <h4 class="text-warning">
                                ₹ {{ number_format($project->tax, 2) }}
                            </h4>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center shadow-sm">
                        <div class="card-body">
                            <h6>Grand Total</h6>
                            <h4 class="text-success">
                                ₹ {{ number_format($project->grand_total, 2) }}
                            </h4>
                        </div>
                    </div>
                </div>
            </div>

            {{-- ================= PROJECT SUMMARY ================= --}}
            <div class="row mb-2">
                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5>Total Areas</h5>
                            <h3>{{ $project->areas->count() }}</h3>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5>Total Items</h5>
                            <h3>
                                {{ $project->areas->sum(fn($area) => $area->items->count()) }}
                            </h3>
                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card text-center">
                        <div class="card-body">
                            <h5>Created At</h5>
                            <h6>{{ $project->created_at->format('d M Y') }}</h6>
                        </div>
                    </div>
                </div>
            </div>



            {{-- ================= AREAS LOOP ================= --}}
            @foreach($project->areas as $area)

            <div class="card mb-4">
                <div class="card-header bg-light">
                    <h5 class="mb-0">
                        Area: {{ $area->name }}
                        @if($area->room)
                        <span class="text-muted">
                            (Room: {{ $area->room->name }})
                        </span>
                        @endif
                    </h5>
                </div>

                <div class="card-body">

                    @if($area->items->count() > 0)

                    <div class="table-responsive">
                        <table class="table table-bordered align-middle table-sm">
                            <thead class="table-light">
                                <tr>
                                    <th width="4%">#</th>
                                    <th width="8%">Image</th>
                                    <th width="12%">Product</th>
                                    <th width="10%">SKU</th>
                                    <th width="8%">Qty</th>
                                    <th width="12%">Size</th>
                                    <th width="12%">Room</th>
                                    <th width="10%">Item</th>
                                    <th width="12%">Catalog</th>
                                    <th width="10%">Serial</th>
                                    <th>Description</th>
                                </tr>
                            </thead>

                            <tbody>

                                @foreach($area->items as $index => $item)

                                <tr>
                                    {{-- SL --}}
                                    <td>{{ $index + 1 }}</td>

                                    {{-- IMAGE --}}
                                    <td>
                                       @if($item->is_custom == 0 && $item->variant?->primaryImage?->image_path)
    <img src="{{ asset($item->variant->primaryImage->image_path) }}" width="60">
@else
    <span>No Image</span>
@endif

                                      
                                    </td>

                                    {{-- PRODUCT --}}
                                    <td>
                                        {{ $item->product->name ?? 'N/A' }}
                                    </td>

                                    {{-- SKU --}}
                                    <td>
                                        {{ $item->variant->sku ?? '-' }}
                                    </td>

                                    {{-- QTY --}}
                                    <td>
                                        {{ $item->quantity ?? 1 }}
                                    </td>

                                    {{-- SIZE --}}
                                    <td>
                                        @if($item->measurement)
                                        {{ $item->measurement->width ?? '-' }}
                                        x
                                        {{ $item->measurement->height ?? '-' }}
                                        {{ $item->measurement->unit ?? '' }}
                                        @else
                                        -
                                        @endif
                                    </td>

                                    {{-- ROOM --}}
                                    <td>
                                        {{ $area->area_name ?? $area->name ?? '-' }}
                                    </td>

                                    {{-- ITEM CATEGORY --}}
                                    <td>
                                        {{ ucfirst($item->category ?? '-') }}
                                    </td>

                                    {{-- CATALOG --}}
                                    <td>
                                        {{
                        $item->curtain->catalogue ??
                        $item->wallpaper->catalogue ??
                        $item->sofa->fabric_catalogue ??
                        '-'
                    }}
                                    </td>

                                    {{-- SERIAL --}}
                                    <td>
                                        {{
                        $item->curtain->serial_no ??
                        $item->wallpaper->serial_no ??
                        $item->sofa->serial_no ??
                        '-'
                    }}
                                    </td>

                                    {{-- DESCRIPTION --}}
                                    <td>
                                        {{ $item->notes ?? '-' }}
                                    </td>

                                </tr>

                                @endforeach

                            </tbody>
                        </table>
                    </div>


                    @else
                    <p class="text-muted">No items found in this area.</p>
                    @endif

                </div>
            </div>

            @endforeach

      
        <a href="{{ route('projects.index') }}" class="btn btn-secondary mt-3">Back to Projects</a>

    </div>
</div>

@endsection